/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rsf;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class RsfManager {
    private static final String TRACE_MASKT = "XRSFMGRT";
    private static final String TRACE_MASKF = "XRSFMGRF";
    private static final String TRACE_MASKD = "XRSFMGRD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RSF-Mgr");
    private static final String DFC_RSFCONFIG_ID = "rsfconfig";
    private static final String IMPL_PREFIX = "impl_";
    private static final String CONFIG_PREFIX = "config_";
    private static final String CONFIG_SUFFIX = ".xml";
    private static final String SETTINGS_CONFIG = "RsfSettings";
    private static RsfManager rsfManager = null;
    private static String defaultImplId;
    private static Map rsfImpls;
    private static Object rsfImplsLock;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rsf$RemoteSupportFacility;

    private RsfManager() {
        this.init();
        Trace.trace(TRACE_MASKT, "<> RsfManager()");
    }

    public static synchronized RsfManager getRsfManager() {
        Trace.trace(TRACE_MASKT, "-> getRsfManager()");
        if (rsfManager == null) {
            rsfManager = new RsfManager();
        }
        Trace.trace(TRACE_MASKT, "<- getRsfManager()");
        return rsfManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteSupportFacility getRsf(String implId) {
        Trace.trace(TRACE_MASKT, "-> getRsf() called for impl id: " + implId);
        RemoteSupportFacility rsf = null;
        Object object = rsfImplsLock;
        synchronized (object) {
            rsf = (RemoteSupportFacility)rsfImpls.get(implId);
        }
        if (rsf != null) {
            Trace.trace(TRACE_MASKT, "<- getRsf() Ok");
        } else {
            Trace.trace(TRACE_MASKT, "<- getRsf() Failed, returning null");
        }
        return rsf;
    }

    public RemoteSupportFacility getPreferredRsf(String implId) {
        Trace.trace(TRACE_MASKT, "-> getPreferredRsf() called for impl id: " + implId);
        RemoteSupportFacility rsf = this.getRsf(implId);
        if (rsf == null) {
            rsf = this.getConsoleRsf();
        }
        if (rsf != null) {
            Trace.trace(TRACE_MASKT, "<- getPreferredRsf() Ok");
        } else {
            Trace.trace(TRACE_MASKT, "<- getPreferredRsf() Failed, returning null");
        }
        return rsf;
    }

    public RemoteSupportFacility getConsoleRsf() {
        Trace.trace(TRACE_MASKT, "-> getConsoleRsf()");
        RemoteSupportFacility rsf = this.getRsf(defaultImplId);
        if (rsf != null) {
            Trace.trace(TRACE_MASKT, "<- getConsoleRsf() Ok");
        } else {
            Trace.trace(TRACE_MASKT, "<- getConsoleRsf() Failed, returning null");
        }
        return rsf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllRsf() {
        HashSet impls;
        Trace.trace(TRACE_MASKT, "-> getAllRsf()");
        Object object = rsfImplsLock;
        synchronized (object) {
            impls = new HashSet(rsfImpls.values());
        }
        Trace.trace(TRACE_MASKT, "<- getAllRsf() " + impls.size());
        return impls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Trace.trace(TRACE_MASKT, "-> init()");
        boolean foundConsDefaultImpl = false;
        try {
            String configPath = BaseFileControl.getFilePath(DFC_RSFCONFIG_ID);
            Trace.trace(TRACE_MASKF, "Rsf config path=" + configPath);
            String rsfSettingsName = "config_RsfSettings.xml";
            File rsfSettingsFile = new File(configPath, rsfSettingsName);
            Trace.trace(TRACE_MASKF, "Config file=" + rsfSettingsFile);
            ConfigXmlHandler cfgHandler = new ConfigXmlHandler();
            try {
                SettingsData settingsData = cfgHandler.parseSettingsXML(new FileReader(rsfSettingsFile));
                defaultImplId = settingsData.defaultImplId;
                Trace.trace(TRACE_MASKF, "Console default impl id=" + defaultImplId);
            }
            catch (Exception e2) {
                String desc = "Exception processing RSF configuration " + rsfSettingsFile + ":\n" + this.getStackTrace(e2);
                Trace.trace(TRACE_MASKF, desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1136);
                fl.add(desc);
                fl.log();
            }
            File[] implFiles = new File(configPath).listFiles(new ImplFileFilter());
            for (int i = 0; i < implFiles.length; ++i) {
                Trace.trace(TRACE_MASKF, "Impl file=" + implFiles[i]);
                try {
                    ImplData implData = cfgHandler.parseRsfXML(new FileReader(implFiles[i]));
                    RemoteSupportFacility rsfImpl = this.createRsf(implData.implClass);
                    if (rsfImpl == null) continue;
                    String rsfImplId = rsfImpl.getImplId();
                    Object object = rsfImplsLock;
                    synchronized (object) {
                        String desc;
                        if (!rsfImpls.containsKey(rsfImplId)) {
                            rsfImpls.put(rsfImplId, rsfImpl);
                            desc = "Successfully configured " + rsfImplId;
                            Trace.trace(TRACE_MASKF, desc);
                            if (rsfImplId.equals(defaultImplId)) {
                                foundConsDefaultImpl = true;
                            }
                        } else {
                            desc = "Duplicate implementation identifier (" + rsfImplId + ") specified by " + implFiles[i];
                            Trace.trace(TRACE_MASKF, desc);
                            FrameworkLog fl = new FrameworkLog(classLogInfo, 1136);
                            fl.add(desc);
                            fl.log();
                        }
                        continue;
                    }
                }
                catch (Exception e2) {
                    String desc = "Exception processing RSF configuration " + implFiles[i] + ":\n" + this.getStackTrace(e2);
                    Trace.trace(TRACE_MASKF, desc);
                    FrameworkLog fl = new FrameworkLog(classLogInfo, 1136);
                    fl.add(desc);
                    fl.log();
                }
            }
        }
        catch (Exception e) {
            String desc = "Exception during RSF initialization:\n" + this.getStackTrace(e);
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1136);
            fl.add(desc);
            fl.log();
        }
        if (!foundConsDefaultImpl) {
            String desc = "Console default implementation (" + defaultImplId + ") not configured";
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1136);
            fl.add(desc);
            fl.log();
        }
        Trace.trace(TRACE_MASKF, "Configured " + rsfImpls.size() + " RSF implementations");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    private RemoteSupportFacility createRsf(String implClassName) throws Exception {
        Class<?> implClass = Class.forName(implClassName);
        Method theMethod = implClass.getDeclaredMethod("getRsf", new Class[0]);
        int mods = theMethod.getModifiers();
        if (theMethod.getReturnType() != (class$com$ibm$hwmca$fw$rsf$RemoteSupportFacility == null ? (class$com$ibm$hwmca$fw$rsf$RemoteSupportFacility = RsfManager.class$("com.ibm.hwmca.fw.rsf.RemoteSupportFacility")) : class$com$ibm$hwmca$fw$rsf$RemoteSupportFacility) || !Modifier.isPublic(mods) || !Modifier.isStatic(mods)) {
            String desc = implClassName + " 'getRsf()' method has wrong return type or modifiers";
            throw new RuntimeException(desc);
        }
        return (RemoteSupportFacility)theMethod.invoke(null, null);
    }

    private String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        throwable.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        rsfImpls = new HashMap();
        rsfImplsLock = new Object();
    }

    class ConfigXmlHandler
    extends DefaultHandler {
        private static final String ELEMENT_CLASS = "Class";
        private static final String ELEMENT_DEFAULT_IMPLID = "ConsDefaultImplId";
        private XMLReader xmlReader = new SAXParser();
        private StringBuffer chars = new StringBuffer();
        private ImplData implData;
        private SettingsData settingsData;

        public ConfigXmlHandler() {
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setErrorHandler(this);
        }

        public synchronized SettingsData parseSettingsXML(Reader reader) throws IOException, SAXException {
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", true);
            this.xmlReader.parse(new InputSource(reader));
            return this.settingsData;
        }

        public synchronized ImplData parseRsfXML(Reader reader) throws IOException, SAXException {
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", true);
            this.xmlReader.parse(new InputSource(reader));
            return this.implData;
        }

        public void startDocument() throws SAXException {
            this.chars.setLength(0);
            this.implData = new ImplData();
            this.settingsData = new SettingsData();
        }

        public void endDocument() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.chars.setLength(0);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals(ELEMENT_CLASS)) {
                this.implData.implClass = this.chars.toString();
            } else if (localName.equals(ELEMENT_DEFAULT_IMPLID)) {
                this.settingsData.defaultImplId = this.chars.toString();
            }
            this.chars.setLength(0);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.chars.append(ch, start, length);
        }
    }

    class ImplData {
        String implClass = null;

        ImplData() {
        }
    }

    class SettingsData {
        String defaultImplId = null;

        SettingsData() {
        }
    }

    class ImplFileFilter
    implements FilenameFilter {
        ImplFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(RsfManager.IMPL_PREFIX) && name.endsWith(RsfManager.CONFIG_SUFFIX);
        }
    }

    public static class Init
    implements Runnable {
        public void run() {
            Trace.trace(RsfManager.TRACE_MASKT, "-> Initialization beginning");
            RsfManager.getRsfManager();
            Trace.trace(RsfManager.TRACE_MASKT, "<- Initialization ending");
        }
    }
}

